program watts_calc
implicit none

character(len=32) :: opt0
character(len=32) :: opt1
character(len=32) :: opt2
character(len=32) :: opt3
character(len=32) :: opt4

character(len=32) :: tab
character(len=32) :: zero_err

character(len=32) :: watts_out
character(len=32) :: volts_out
character(len=32) :: amps_out

character(len=32) :: get_watts
character(len=32) :: get_volts
character(len=32) :: get_amps

integer :: choice
real :: watts, volts, amps

opt0 = ("Select value to find")
opt1 = ("1.	Watts")
opt2 = ("2.	Volts")
opt3 = ("3.	Amps")
opt4 = ("Choose (1-3):")

 tab = "	"
zero_err = ("**** Divide by zero error ****")

watts_out = ("Watts:")
volts_out = ("Volts:")
amps_out = ("Amps:")

get_watts = ("Enter watts:")
get_volts = ("Enter volts:")
get_amps = ("Enter amps:")

call clear_screen()
call splash()
call options()
read (*,*) choice

select case (choice)

case(1)
	call clear_screen()
	call splash()

	print *, get_volts
	read (*,*) volts

	print *, get_amps
	read (*,*) amps

	watts = volts * amps

	call clear_screen()
	call splash()

	print *, volts_out, tab, volts
	print *, amps_out, tab, amps
	print *, watts_out, tab, watts

case(2)
	call clear_screen()
	call splash()

	print *, get_watts
	read (*,*) watts

	print *, get_amps
	read (*,*) amps
	
	if(amps == 0.0) then
		print *, zero_err
		stop
	endif

	volts = watts / amps

	call clear_screen()
	call splash()

	print *, watts_out, tab, watts
	print *, amps_out, tab, amps
	print *, volts_out, tab, volts

case(3)
	call clear_screen()
	call splash()

	print *, get_watts
	read (*,*) watts

	print *, get_volts
	read (*,*) volts

	if(volts == 0.0) then
		print *, zero_err
		stop
	endif

	amps = watts / volts

	call clear_screen()
	call splash()

	print *, watts_out, tab, watts
	print *, volts_out, tab, volts
	print *, amps_out, tab, amps

case default
	print *, ("**** Invalid choice ****")
end select
        
	contains

                subroutine clear_screen()
                        call system("clear")
                end subroutine clear_screen

                subroutine splash()
                        print *, "---- ---- ---- ----"
                        print *, "watts"
                        print *, "---- ---- ---- ----"
                end subroutine splash

                subroutine options()
                        print *, opt0
                        print *, opt1
                        print *, opt2
                        print *, opt3
                        print *, opt4
                end subroutine options
end program watts_calc
