#include <iostream>
#include <unistd.h>
#include <fstream>
#include <string>

constexpr const char* tab = "	";
int spl_cnt = 0;
int cnt = 8;

constexpr const char* spl[6] =
	{
	"████████╗███████╗██████╗ ███╗   ███╗███████╗\n",
	"╚══██╔══╝██╔════╝██╔══██╗████╗ ████║██╔════╝\n",
	"   ██║   █████╗  ██████╔╝██╔████╔██║███████╗\n",
	"   ██║   ██╔══╝  ██╔══██╗██║╚██╔╝██║╚════██║\n",
	"   ██║   ███████╗██║  ██║██║ ╚═╝ ██║███████║\n",
	"   ╚═╝   ╚══════╝╚═╝  ╚═╝╚═╝     ╚═╝╚══════╝\n"
	};

void print_tabs(int cnt) {
	using namespace std;
    for (int i = 0; i < cnt; ++i) {
        cout << tab;
    }
}

void clear_screen(){
        std::cout << "\033[H\033[2J\033[3J";
}

void splash(){
	using namespace std;
	clear_screen();
	cout << spl[0];
	cout << spl[1];
	cout << spl[2];
	cout << spl[3];
	cout << spl[4];
	cout << spl[5];
}

void splash_animate(){
        using namespace std;
	while(cnt > 0){
                clear_screen();
                while(spl_cnt < 5){
                        print_tabs(cnt);
                        cout << spl[spl_cnt];
                        spl_cnt = spl_cnt + 1;
                }
                spl_cnt = 0;
                cnt = cnt - 1;
                usleep(15000);
        }

        clear_screen();
}

void print_cons_info(){
	std::ifstream cons_info("/proc/consoles");
	if (!cons_info.is_open()){
		std::cerr << "Error could not open /proc/consoles" << std::endl;
		return;
	}

	std::string line;
	while (std::getline(cons_info, line)){
		if 	(line.find("tty") != std::string::npos){
				std::cout << line << std::endl;
				usleep(30000);
				}
			}

	cons_info.close();
}

int main(){
	splash_animate();
	splash();
	print_cons_info();
	std::cout << "\n";
}
