#include <iostream>
#include <vector>
#include <string>
#include <cstring>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <fcntl.h>
#include <unistd.h>

bool is_host_online(const std::string& ip, int port = 22, int timeout_ms = 1000) {
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) return false;

    // Make socket non-blocking
    fcntl(sock, F_SETFL, O_NONBLOCK);

    sockaddr_in addr{};
    addr.sin_family = AF_INET;
    addr.sin_port = htons(port);
    inet_pton(AF_INET, ip.c_str(), &addr.sin_addr);

    int result = connect(sock, (sockaddr*)&addr, sizeof(addr));
    if (result < 0) {
        fd_set write_set;
        FD_ZERO(&write_set);
        FD_SET(sock, &write_set);

        timeval timeout{};
        timeout.tv_sec = timeout_ms / 1000;
        timeout.tv_usec = (timeout_ms % 1000) * 1000;

        result = select(sock + 1, nullptr, &write_set, nullptr, &timeout);
        if (result > 0) {
            int err = 0;
            socklen_t len = sizeof(err);
            getsockopt(sock, SOL_SOCKET, SO_ERROR, &err, &len);
            close(sock);
            return err == 0;
        }
        close(sock);
        return false;
    }

    close(sock);
    return true;
}

int main() {
    std::vector<std::string> ips = {
        "192.168.0.80",
        "192.168.0.113",
        "192.168.0.174",
	"192.168.0.252",
    };

    for (const auto& ip : ips) {
        bool online = is_host_online(ip);
        std::cout << (online ? "ONLINE" : "OFFLINE") << "	<---->	| " << ip << "\n";
    }

    return 0;
}
