#include <iostream>
#include <fstream>
#include <string>
#include <unistd.h>

constexpr const char* tab = "	";
constexpr const char* clear = "\033[H\033[2J\033[3J";
int spl_cnt = 0;
int cnt = 8;

void printMEMinfo(){
	std::ifstream meminfo("/proc/meminfo");
	if (!meminfo.is_open()){
		std::cerr << "Error could not open /proc/meminfo" << std::endl;
		return;
	}

	std::string line;
	while (std::getline(meminfo, line)){
		if 	(line.find("MemTotal:") != std::string::npos ||
			 line.find("MemFree:") != std::string::npos ||
			 line.find("Cached:") != std::string::npos ||
			 line.find("Percpu:") != std::string::npos||
			 line.find("HardwareCorrupted:") != std::string::npos||
			 line.find("KernelStack:") != std::string::npos){
				std::cout << line << "\n";
				}
			}
		
	meminfo.close();
}

constexpr const char* spl[6] =
	{ 
	"███╗   ███╗███████╗███╗   ███╗\n",
	"████╗ ████║██╔════╝████╗ ████║\n",
	"██╔████╔██║█████╗  ██╔████╔██║\n",
	"██║╚██╔╝██║██╔══╝  ██║╚██╔╝██║\n",
	"██║ ╚═╝ ██║███████╗██║ ╚═╝ ██║\n",
	"╚═╝     ╚═╝╚══════╝╚═╝     ╚═╝\n"
	};

void print_tabs(int cnt) {
	using namespace std;
    for (int i = 0; i < cnt; ++i) {
        cout << tab;
    }
}

void splash_animate(){
        using namespace std;
	while(cnt > 0){
                std::cout << clear;
                while(spl_cnt < 5){
                        print_tabs(cnt);
                        cout << spl[spl_cnt];
                        spl_cnt = spl_cnt + 1;
                }
                spl_cnt = 0;
                cnt = cnt - 1;
                usleep(15000);
        }

        std::cout << clear;
}

void splash(){
	using namespace std;
	std::cout << clear;
	cout << spl[0];
	cout << spl[1];
	cout << spl[2];
	cout << spl[3];
	cout << spl[4];
	cout << spl[5];
}

int main(){
while(true){
	std::cout << clear;
	splash();
	printMEMinfo();
	std::cout << "\n";
	usleep(1000000);
}
	return 0;

}
