#include <iostream>
#include <fstream>
#include <string>
#include <unistd.h>

constexpr const char* tab = "	";
int spl_count = 0;
int cnt = 8;

void printMEMinfo(){
	std::ifstream meminfo("/var/run/dmesg.boot");
	if (!meminfo.is_open()){
		std::cerr << "Error could not open /var/run/dmesg.boot" << std::endl;
		return;
	}

	std::string line;
	while (std::getline(meminfo, line)){
		if 	(line.find("memory") != std::string::npos){
				std::cout << line << std::endl;
				}
			}
		
	meminfo.close();
}

void clear_screen(){
        std::cout << "\033[H\033[2J\033[3J";
}

constexpr const char* spl[6] =
	{ 
	"███╗   ███╗███████╗███╗   ███╗\n",
	"████╗ ████║██╔════╝████╗ ████║\n",
	"██╔████╔██║█████╗  ██╔████╔██║\n",
	"██║╚██╔╝██║██╔══╝  ██║╚██╔╝██║\n",
	"██║ ╚═╝ ██║███████╗██║ ╚═╝ ██║\n",
	"╚═╝     ╚═╝╚══════╝╚═╝     ╚═╝\n"
	};

void print_tabs(int cnt) {
	using namespace std;
    for (int i = 0; i < cnt; ++i) {
        cout << tab;
    }
}

void splash_animate(){
        using namespace std;
	while(cnt > 0){
                clear_screen();
                while(spl_count < 5){
                        print_tabs(cnt);
                        cout << spl[spl_count];
                        spl_count = spl_count + 1;
                }
                spl_count = 0;
                cnt = cnt - 1;
                usleep(15000);
        }

        clear_screen();
}

void splash(){
	using namespace std;
	clear_screen();
	cout << spl[0];
	cout << spl[1];
	cout << spl[2];
	cout << spl[3];
	cout << spl[4];
	cout << spl[5];
}

int main(){
	clear_screen();
	splash_animate();
	splash();
	usleep(40000);
	printMEMinfo();
	std::cout << "\n";
	return 0;
}
