#include <stdio.h>
#include <string.h>
#include <time.h>
#include <dirent.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>

int state = 1;
char input[100];

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

// Returns a suffix string depending on file type
const char* getTypeSuffix(const char* name) {
    static char suffix[2]; // one char + null terminator
    struct stat st;

    if (stat(name, &st) == -1) {
        // If stat fails, return empty string
        return "";
    }

    if (S_ISDIR(st.st_mode)) {
        suffix[0] = '/';
        suffix[1] = '\0';
        return suffix;
    }

    if (st.st_mode & S_IXUSR) {
        suffix[0] = '*';
        suffix[1] = '\0';
        return suffix;
    }

    return "";
}


int compareStrings(const void* a, const void* b) {
    const char* s1 = *(const char**)a;
    const char* s2 = *(const char**)b;
    return strcmp(s1, s2);
}

void print_shell() {
    printf("smid_sh# ");
}

void test() {
    printf("Shell input successful\n\a");
}

void do_exit() {
    printf("Exiting\n");
    state = 0;
}

void get_input() {
    if (fgets(input, sizeof(input), stdin) == NULL) {
        input[0] = '\0';
        return;
    }
    // Remove trailing newline
    input[strcspn(input, "\n")] = '\0';
}


void _unix(){
	time_t result = time(NULL);
	printf("Unix Timestamp: %ld\n", result);
}

void ls() {
    DIR* dir;
    struct dirent* entry;
    char** files = NULL;
    size_t count = 0;

    dir = opendir(".");
    if (dir == NULL) {
        printf("Failed to open directory\n");
        return;
    }

    while ((entry = readdir(dir)) != NULL) {
        if (strcmp(entry->d_name, ".") != 0 && strcmp(entry->d_name, "..") != 0) {
            // Allocate space for new entry
            files = realloc(files, (count + 1) * sizeof(char*));
            if (files == NULL) {
                perror("realloc");
                closedir(dir);
                return;
            }
            files[count] = strdup(entry->d_name);
            if (files[count] == NULL) {
                perror("strdup");
                closedir(dir);
                return;
            }
            count++;
        }
    }
    closedir(dir);

    // Sort the list
    qsort(files, count, sizeof(char*), compareStrings);

    // Print results
    for (size_t i = 0; i < count; i++) {
        printf("%s%s\n", files[i], getTypeSuffix(files[i]));
        usleep(5000);
        free(files[i]); // free each string
    }
    free(files); // free the array
}

void date() {
    struct timespec ts;
    if (clock_gettime(CLOCK_REALTIME, &ts) == -1) {
        perror("clock_gettime");
        return;
    }

    struct tm timeinfo;
    if (localtime_r(&ts.tv_sec, &timeinfo) == NULL) {
        perror("localtime_r");
        return;
    }

    char buffer[100];
    if (strftime(buffer, sizeof(buffer), "%a %b %d %H:%M:%S %Z %Y", &timeinfo) == 0) {
        fprintf(stderr, "strftime returned 0\n");
        return;
    }

    printf("%s\n", buffer);
}

void whoami(){
        const char*  username = getenv("USER");
                if (username) {
                        printf("%s\n",username);
                } else {
        perror("Failed to get username.");
        }
}

void cat(const char* filename) {
    FILE* file = fopen(filename, "r");
    if (!file) {
        perror("cat");
        return;
    }

    char buffer[256];
    while (fgets(buffer, sizeof(buffer), file)) {
        printf("%s", buffer);
    }

    fclose(file);
}

void nl(const char* filename) {
    FILE* file = fopen(filename, "r");
    if (!file) {
        perror("nl");
        return;
    }

    char buffer[256];
    int line = 1;
    while (fgets(buffer, sizeof(buffer), file)) {
        printf("%6d\t%s", line++, buffer);
    }

    fclose(file);
}

void cd(const char* path) {
    if (path == NULL) {
        // Default to home directory if no argument
        const char* home = getenv("HOME");
        if (home == NULL) {
            fprintf(stderr, "cd: HOME not set\n");
            return;
        }
        path = home;
    }

    if (chdir(path) != 0) {
        perror("cd");
    }
}

void execute_program(const char* path, char* const argv[]) {
    pid_t pid = fork();
    if (pid == -1) {
        perror("fork");
        return;
    }

    if (pid == 0) {
        // Child process: replace with new program
        execvp(path, argv);
        // If execvp returns, there was an error
        perror("execvp");
        exit(EXIT_FAILURE);
    } else {
        // Parent process: wait for child to finish
        int status;
        if (waitpid(pid, &status, 0) == -1) {
            perror("waitpid");
        }
    }
}


void help(){
	printf("Available commands:\n");
	printf("exit\n");
	printf("test\n");
	printf("clear\n");
	printf("unix\n");
	printf("ls\n");
	printf("date\n");
	printf("whoami\n");
	printf("cat\n");
	printf("nl\n");
	printf("cd\n");
	printf("help\n");
	printf("exec\n");
}

void clear_screen(){
	printf("\033[H\033[2J\033[3J");
}


int main() {
    while (state != 0) {
        print_shell();
        get_input();

	char* cmd = strtok(input, " ");
	char* arg = strtok(NULL, " ");

	if(cmd == NULL) continue;

        if (strcmp(input, "exit") == 0) {
		do_exit();
        }
        else if (strcmp(input, "test") == 0) {
		test();
        }
	else if (strcmp(input, "clear") == 0){
		clear_screen();
	}
	else if (strcmp(input, "unix") == 0){
		_unix();
	}
	else if (strcmp(input, "ls") == 0){
		ls();
	}
	else if (strcmp(input, "date") == 0){
		date();
	}
	else if (strcmp(input, "whoami") == 0){
		whoami();
	}
	else if (strcmp(cmd, "cat") == 0){
		if (arg){
			cat(arg);
		} else {
			printf("Usage: cat <filename>\n");
		}
	}
	else if (strcmp(cmd, "nl") == 0) {
	    if (arg) {
        	nl(arg);
    	} else {
        	printf("Usage: nl <filename>\n");
    		}
	}
	else if (strcmp(cmd, "cd") == 0) {
    		cd(arg);
	}

	else if(strcmp(cmd, "help") == 0) {
		help();
	}
	else {
	// Build argv array for execvp
    	char* argv[10]; // supports up to 10 args for now
    	int argc = 0;
    	argv[argc++] = cmd;

    	while ((arg = strtok(NULL, " ")) != NULL && argc < 9) {
        	argv[argc++] = arg;
    	}
    	argv[argc] = NULL; // execvp requires NULL-terminated argv

    	// Try executing the command
    	execute_program(cmd, argv);
	}
}
    return 0;
}
