	ORG 0x0000				;START OF BOOTLOADER CODE

	;STEP 1: INITIALIZATION
	LD SP, 0xFFFF				;SET STACK POINTER TO TOP OF RAM

	;CLEAR ALL REGISTERS (OPTIONAL, FOR SAFETY)
	XOR A					;CLEAR ACCUMULATOR
	LD B, A					;CLEAR B
	LD C, A					;CLEAR C
	LD D, A					;CLEAR D
	LD E, A					;CLEAR E
	LD H, A					;CLEAR H
	LD L, A					;CLEAR L

	;STEP 2: LOAD PROGRAM (THIS IS HIGHLY DEPENDENT ON HARDWARE)
	;FOR EXAMPLE, IF LOADING FROM ROM AT ADDRESS 0x8000 TO RAM AT ADDRESS 0x2000
LOAD_PROGRAM:
	LD HL, 0x8FFF				;SOURCE ADDRESS IN ROM
	LD DE, 0x2000				;DESTINATION ADDRESS IN RAM
	LD BC, 0x1000				;NUMBER OF BYTES TO COPY

COPY_LOOP:
	LD A, (HL)				;LOAD BYTE FROM ROM
	LD (DE), A				;STORE BYTE IN RAM
	INC HL					;INCREMENT SOURCE ADDRESS
	INC DE					;INCREMENT DESTINATION ADDRESS
	DEC BC					;DECREMENT COUNTER
	LD A, B
	OR C
	JR NZ, COPY_LOOP			;REPEAT UNTIL BC IS ZERO

	;STEP 3: JUMP TO PROGRAM
	JP 0x2000				;JUMP TO THE LOADED PROGRAM'S START ADDRESS

	;END OF BOOT LOADER
