    .global _start
    .section .data
result:
    .int32 0                                    //reserve space for the result

    .text
_start:
    //prompt the user for a number
    mov x0, #1                                //syscall: write
    mov x1, #4                                //stdout
    ldr x2, =message                        //the message to display
    ldr x7, 32                    //the length of the message
    svc 0                                        //system call

    //read the user's input
    mov x0, #0                                //syscall: read
    ldr x1, =stdin                            //stdin
    ldr x2, =number                            //the buffer to store the number in
    mov x3, #8                                //the maximum number of bytes to read
    svc 0                                        //system call

    //convert the input string into a double
    ldr x1, =number
    ldr x2, [x1]                                //load the number (as a string) onto the FPU stack
    flds x2                                        //load the number (as a float) onto the FPU stack
    fsqrt                                        //compute the square root
    strd x2, [result]                            //store the result (result now contains sqrt(number))

    //print the result to the terminal
    mov x0, #1                                //syscall: write
    mov x1, #4                                //stdout
    ldr x2, =result                            //the address of the result buffer
    mov x7, #8                                //the length of the result buffer
    svc 0                                        //system call

    //exit the program (just for the sake of having a complete example)
    mov x7, #60                                //syscall: exit
    mov x0, #0                                //status: 0
    svc 0                                        //system call
